// EngineerTurretTrap function 0.3 by Dewy
// The role of this plugin is primarily just to be a educational refference for scripters.
// (But it does work quite well.)
// Coordinates have to be set, else returns False.
// $ options: ex. ---> $EngineerTurret = Break; <---
//		Break = Bailout of the operation before it recycles.

MiniMod::MonitorFile(start, "Engineer Turret.CodeFusion.cs", "A Multi-purpose, user configurable turret.");

function EngineerTurretTrap(%this, %target, %force, %strongArm)
{
%targetPos = GameBase::getPosition(%this);
%client = %target;
if (Player::getArmor(%client) == False) // If the client is dead then clean up here and quit looping.
	{
	   $EngineerTurret[%client] = ""; // Clean up dead entries.
	   return False;  // Bail out.
	   break;
	}
	if(%targetPos != "")
	{
	   $EngineerTurret[%client] = ""; // If there's new coordinates then delete the old ones.
	   $EngineerTurret[%client] = %targetPos; // Set the new ones.
	}
   else
   {
	if(%targetPos == "")
	{
	   %targetPos = $EngineerTurret[%client]; // If there's no coordinants then look in the client's table.
	}
   }
// Get client position.
		%clientPos = GameBase::getPosition(%client);
		%clientX = getWord(%clientPos,0);
		%clientY = getWord(%clientPos,1);
		%clientZ = getWord(%clientPos,2);
// Setup Speed controls.
		%speed = Item::getVelocity(%client);
		%speedX = getWord(%speed, 0);
		%speedY = getWord(%speed, 1);
		%speedZ = getWord(%speed, 2);
// Setup Impulse info
		%setPosX = getWord(%targetPos,0);
		%setPosY = getWord(%targetPos,1);
		%setPosZ = getWord(%targetPos,2);
		%mathX = Vector::neg(%clientX);
		%mathY = Vector::neg(%clientY);
		%mathZ = Vector::neg(%clientZ);
		%destPosX = %setPosX+%mathX;
		%destPosY = %setPosY+%mathY;
		%destPosZ = %setPosZ+%mathZ;
		%reverseX = Vector::neg(%destPosX);
		%reverseY = Vector::neg(%destPosY);
		%reverseZ = Vector::neg(%destPosZ);

// Set the requested force. (Atract/Repel) Default is Atract.
		if(%force == repel)
		{
			%destPosX = %reverseX;
			%destPosY = %reverseY;
			%destPosZ = %reverseZ;
		}

// Get Distance.
		%dist = Vector::getDistance(%clientPos, %targetPos);
		%Xdist = Vector::getDistance(%clientX, %setPosX);
		%Ydist = Vector::getDistance(%clientY, %setPosY);
		%Zdist = Vector::getDistance(%clientZ, %setPosZ);
// Emergency Brakes.
		%brakeX = Vector::neg(%speedX); //*0.25;
		%brakeY = Vector::neg(%speedY); //*0.25;
// Finite Vertical Navigation.
		%parachuteVal = Vector::neg(%speedZ)*0.25;
		%vertAdjust = %setPosZ-%clientZ+3;
	if(%setPosZ >= %clientZ)
	{
		if(%dist <= 25)
		{
			if(%vertAdjust <= 5)
			{
				Player::ApplyImpulse(%client, "0 0 "@%vertAdjust);
			}
			else
			{
				if(%destPosZ >= 0)
				{
					Player::ApplyImpulse(%client, "0 0 5");
				}
			}
		}
	}
 // Don't make the client go "FWING!!!" (In any direction.) :P :)
	if(%dist >= 25) // Coarse Flight.
	{
		if(%speedX <=  -10){if(%destPosX <= -1){%destPosX = -0.1;}} //%destPosX*0.010;}}
		if(%speedY <= -10){if(%destPosY <= -1){%destPosY = -0.1;}} //%destPosY*0.010;}}
		if(%speedZ <= -15){if(%destPosZ <= -1){%destPosZ = %destPosZ*0.010;}}
		if(%speedZ <= -0.000015){if(%destPosZ <= -0.000015){%destPosZ = %destPosZ+Vector::neg(%destPosZ);}}
		if(%speedX >= 10){if(%destPosX >= 1){%destPosX = %destPosX*-0.010;}} //0.1;}}
		if(%speedY >= 10){if(%destPosY >= 1){%destPosY = %destPosY*-0.010;}} //0.1;}}
		if(%speedZ >= 15){if(%destPosZ >= 1){%destPosZ = %destPosZ*-0.010;}}
		if(%speedZ >= 0.000015){if(%destPosZ >= 0.000015){%destPosZ = %destPosZ+Vector::neg(%destPosZ);}}
		if(%speedX <= -15){%destPosX = %brakeX;}
		if(%speedY <= -15){%destPosY = %brakeY;}
		if(%speedZ <= -0.1){Player::ApplyImpulse(%client, "0 0 "@%parachuteVal);}
		if(%speedX >= 15){%destPosX = %brakeX;} 
		if(%speedY >= 15){%destPosY = %brakeY;} 
		if(%speedZ >= 25){Player::ApplyImpulse(%client, "0 0 "@%vertAdjust);} //parachuteVal);} 
//		if(%speedZ <= 1){Player::ApplyImpulse(%client, "0 0 "@%vertAdjust);} //parachuteVal);} 
	}
	if(%dist <= 25) // The Alignment.
	{
//		if(%dist >= 10)
//		{
			if(%speedX <=  -10){if(%destPosX <= -5){%destPosX = %destPosX*0.010;}}
			if(%speedY <= -10){if(%destPosY <= -5){%destPosY = %destPosY*0.010;}}
			if(%speedZ <= -10){if(%destPosZ <= -5){%destPosZ = %destPosZ*0.010;}}
			if(%speedX >= 10){if(%destPosX >= 5){%destPosX = %destPosX*-0.010;}}
			if(%speedY >= 10){if(%destPosY >= 5){%destPosY = %destPosY*-0.010;}}
			if(%speedZ >= 10){if(%destPosZ >= 5){%destPosZ = %destPosZ*-0.010;}}
			if(%speedX >= 15){%destPosX = %brakeX;} 
			if(%speedX <= -15){%destPosX = %brakeX;}
			if(%speedY >= 15){%destPosY = %brakeY;} 
			if(%speedY <= -15){%destPosY = %brakeY;}
			if(%speedZ >= 15){Player::ApplyImpulse(%client, "0 0 "@%parachuteVal);} 
			if(%speedZ <= -0.1){Player::ApplyImpulse(%client, "0 0 "@%parachuteVal);}
			Player::ApplyImpulse(%client, "0 0 "@%vertAdjust);
//		}
	}
//	if(%dist <= 10) // The Landing.
//	{
//		if(%force != repel)
//		{
//			if(%speedX <=  -5){if(%destPosX <= -1){%destPosX = %destPosX*0.10;}}
//			if(%speedY <= -5){if(%destPosY <= -1){%destPosY = %destPosY*0.10;}}
//			if(%speedZ <= -5){if(%destPosZ <= -1){%destPosZ = %destPosZ*0.10;}}
//			if(%speedX >= 5){if(%destPosX >= 1){%destPosX = %destPosX*-0.10;}}
//			if(%speedY >= 5){if(%destPosY >= 1){%destPosY = %destPosY*-0.10;}}
//			if(%speedZ >= 5){if(%destPosZ >= 0.11){%destPosZ = %destPosZ*-0.20;}}
//			if(%speedX >= 7){%destPosX = %brakeX;} 
//			if(%speedX <= -7){%destPosX = %brakeX;}
//			if(%speedY >= 7){%destPosY = %brakeY;} 
//			if(%speedY <= -7){%destPosY = %brakeY;}
//			if(%speedZ >= 15){%destPosZ = %parachuteVal;} 
//			if(%speedZ <= -15){%destPosZ = %parachuteVal;}
//			Item::setVelocity(%target,"0 0 0.5");
//		}
//		else
//		{
//			if(%speedX <=  -5){if(%destPosX <= -1){%destPosX = %destPosX*1000;}}
//			if(%speedY <= -5){if(%destPosY <= -1){%destPosY = %destPosY*1000;}}
//			if(%speedZ <= -5){if(%destPosZ <= -1){%destPosZ = %destPosZ*1000;}}
//			if(%speedX >= 5){if(%destPosX >= 1){%destPosX = %destPosX*-1000;}}
//			if(%speedY >= 5){if(%destPosY >= 1){%destPosY = %destPosY*-1000;}}
//			if(%speedZ >= 5){if(%destPosZ >= 0.11){%destPosZ = %destPosZ*-2000;}}
//			if(%speedX >= 3){%destPosX = %brakeX;} 
//			if(%speedX <= -3){%destPosX = %brakeX;}
//			if(%speedY >= 3){%destPosY = %brakeY;} 
//			if(%speedY <= -3){%destPosY = %brakeY;}
//			if(%speedZ >= 15){%destPosZ = %parachuteVal;} 
//			if(%speedZ <= -0.1){%destPosZ = %parachuteVal;}
//			Item::setVelocity(%target,"0 0 2");
//		}
//	}

	// Finite Horizontal Navigation.
	if(%Xdist <= 15)
	{
		if(%Zdist >= 0) // Here we tell EngineerTurret to hold X&Y until Z is in the clear.
		{
			if(%Zdist <= 1)
			{
				if(%Xdist <= 20){if(%speedX <= 3){%lockX = false;}}
			}
			if(%dist <= 0)
			{
				if(%Xdist >= -20){if(%speedX >= -3){%lockX = false;}}
			}
			if(%Zdist >= 1)
			{
//			   if(%Xdist <= 20){%lockX = true;}
//			   if(%Xdist >= -20){%lockX = true;}
			   if(%speedZ >= 3){Player::ApplyImpulse(%client, "0 0 "@%parachuteVal);} 
			   if(%speedZ <= -0.1){Player::ApplyImpulse(%client, "0 0 "@%parachuteVal);}
			   %destPos = ""@%destPosX@" "@%destPosY@" "@%destPosZ@"";
			   Player::ApplyImpulse(%client, %destPos);
			}
		}
	}
	if(%Ydist <= 15)
	{
		if(%Zdist >= 0) // Here we tell EngineerTurret to hold X&Y until Z is in the clear.
		{
			   if(%Zdist <= 1)
			   {
				if(%Ydist <= 20){if(%speedY <= 3){%lockY = false;}}
			   }
			   if(%dist <= 0)
			   {
				if(%Ydist >= -20){if(%speedY >= -3){%lockY = false;}}
			   }
				if(%Zdist >= 1)
				{
//				   if(%Ydist <= 20){%lockY = true;}
//				   if(%Ydist >= -20){%lockY = true;}
				}
				if(%speedZ >= 3){Player::ApplyImpulse(%client, "0 0 "@%parachuteVal);} 
				if(%speedZ <= -0.1){Player::ApplyImpulse(%client, "0 0 "@%parachuteVal);}
				%destPos = ""@%destPosX@" "@%destPosY@" "@%destPosZ@"";
				Player::ApplyImpulse(%client, %destPos);
		}
	}
if(%lockX == true)
	{
//		%destPosX = %brakeX;
	}
	if(%lockY == true)
	{
//		%destPosY = %brakeY;
	}
// Are we stuck? Hmm, lets try to fix it. (For field obsticals.)
	if(%dist >= 10)
	{
		if(%speedY <= 0.1){if(%speedY >= 0){if(%lockX != true){%destPosX = %reverseX*0.001; %stuck = true; %freeUp = "+Y axis. Reversing X to "@%reverseX;}}}
		if(%speedY >= -0.1){if(%speedY <= 0){if(%lockX != true){%destPosX = %reverseX*0.001; %stuck = true; %freeUp = "-Y axis. Reversing X to "@%reverseX;}}}
		if(%speedX <= 0.1){if(%speedX >= 0){if(%lockY != true){%destPosY = %reverseY*0.001; %stuck = true; %freeUp = "+X axis. Reversing Y to "@%reverseY;}}}
		if(%speedX >= -0.1){if(%speedX <= 0){if(%lockY != true){%destPosY = %reverseY*0.001; %stuck = true; %freeUp = "-X axis. Reversing Y to "@%reverseY;}}}
		if(%speedZ <= 0.1){if(%speedZ >= 0){%destPosZ = %reverseZ; %stuck = true; %freeUp = "+Z axis. Reversing "@%reverseZ;Player::ApplyImpulse(%client,"0 0 100");}}
		if(%speedZ >= -0.1){if(%speedZ <= 0){%destPosZ = %reverseZ; %stuck = true; %freeUp = "-Z axis. Reversing "@%reverseZ;}}
	}
	if(%dist >=25)
	{
		%destPos = ""@%destPosX@" "@%destPosY@" "@%destPosZ@""; //0";
	}
	else
	{
		%destPos = ""@%destPosX@" "@%destPosY@" "@%destPosZ@"";
	}
	if(%dist <= 2.5)
	{
		GameBase::setPosition(%client,%clientPos);
	}

// Apply the results.	
//	if(%dist >= 1) // A higher value for faster/sloppier destinations. // In this case turret decides when to stop.
//	{
		if($EngineerTurret != "break") // Override input. (Just in case.)
		{
			if(%destPos != "")
			{
				if(%strongArm == "")
				{
					Player::ApplyImpulse(%client, %destPos); // More true to how it should act.
				}
				else
				{
					Item::setVelocity(%client, %destPos); // Stronger but less forgiving.
				}
//				schedule("EngineerTurretTrap("@%client@");",0.01); // Comment out this line if if your gonna call the function from elsewhere.
// Turret will handle the resheduling in this instance.

				// Note: You'll need your external function call to EngineerTurretTrap repeatedly untill goal is met.
				return %dist; // Tie-in for externals. (For use if external function decides when it should quit.)
			}
		}
//	}
	else
	{
		$EngineerTurret[%client] = ""; // Where all done so its time to clean up.
	}
}

// Now that the EngineerTurretTrap's function is out of the way let setup the more traditional stuff.

// Uncomment the line below if you preffer a classing system over static.
// MiniMod::Turbo::Class(EngineerTurretPack, 10); 
// Sets ItemMax for armors that can carry class 10 items. (Medium deployables)

// And comment these out if wish to rely on only the classing system.
$ItemMax[earmor, EngineerTurretPack] = 1;
$ItemMax[efemale, EngineerTurretPack] = 1;


LightningData EngineerTurretCharge
{
   bitmapName       = "lightningNew.bmp";

   damageType       = $GravDamageType;
   boltLength       = 150.0;
   coneAngle        = 40.0; //40
   damagePerSec      = 0.0;
   energyDrainPerSec = 0.01;
   segmentDivisions = 4;
   numSegments      = 8;
   beamWidth        = 0.05;

   updateTime   = 120;
   skipPercent  = 0.1;
   displaceBias = 0.35;

   lightRange = 3.0;
   lightColor = { 0.15, 0.85, 0.15 };

//   soundId = SoundELFFire; // Caused sound to be played continously if turret was destroyed while firing.
};

function EngineerTurretCharge::damageTarget(%target, %timeSlice, %damPerSec, %enDrainPerSec, %pos, %vec, %mom, %shooterId)
{
	%client = GameBase::getControlClient(%target);
	$EngineerTurretCanShoot[%client] = true;
}

$TeamItemMax[EngineerTurretPack] = 3;

ItemImageData EngineerTurretImage
{
	shapeFile = "camera";
	mountPoint = 2;
	mountOffset = { 0, -0.1, -0.06 };
	mountRotation = { 0, 0, 0 };
	firstPerson = false;
};

ItemData EngineerTurretPack
{
	description = "Engineer Turret";
	shapeFile = "camera";
	className = "Backpack";
   heading = "dDeployables";
	imageType = EngineerTurretImage;
	shadowDetailMask = 4;
	mass = 2.0;
	elasticity = 0.2;
	price = 1000;
	hudIcon = "deployable";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function EngineerTurretPack::onUse(%player,%item)
{
	if (Player::getMountedItem(%player,$BackpackSlot) != %item) {
		Player::mountItem(%player,%item,$BackpackSlot);
	}
	else {
		Player::deployItem(%player,%item);
	}
}

function EngineerTurretPack::onDeploy(%player,%item,%pos)
{
	if (EngineerTurretPack::deployShape(%player,%item)) {
		Player::decItemCount(%player,%item);
		%obj = newObject("","Mine","AntipersonelMine");
		addToSet("MissionCleanup", %obj);
		%pos = GameBase::getPosition(%this);
	    GameBase::setPosition(%obj, %pos);
	}
}

function EngineerTurretPack::deployShape(%player,%item)
{
// 	%client = Player::getClient(%player);
 	%client = GameBase::getControlClient(%player);
	if($TeamItemCount[GameBase::getTeam(%player) @ %item] < $TeamItemMax[%item]) {
		if (GameBase::getLOSInfo(%player,10)) {
			%obj = getObjectType($los::object);
				%prot = GameBase::getRotation(%player);
				%zRot = getWord(%prot,2);
				if (Vector::dot($los::normal,"0 0 1") > 0.6) {
					%rot = "0 0 " @ %zRot;
				}
				else {
					if (Vector::dot($los::normal,"0 0 -1") > 0.6) {
						%rot = "3.14159 0 " @ %zRot;
					}
					else {
						%rot = Vector::getRotation($los::normal);
					}
				}
					%camera = newObject("Camera","Turret",DeployableEngineerTurret,true);
	   	      addToSet("MissionCleanup", %camera);
					GameBase::setTeam(%camera,GameBase::getTeam(%player));
					GameBase::setRotation(%camera,%rot);
					GameBase::setPosition(%camera,$los::position);
					Gamebase::setMapName(%camera,"Engineer Turret #"@ $totalNumCameras++ @ " " @ Client::getName(%client));
					Client::sendMessage(%client,0,"Engineer Turret deployed");
					playSound(SoundPickupBackpack,$los::position);
					$TeamItemCount[GameBase::getTeam(%camera) @ "EngineerTurretPack"]++;
                              Client::setOwnedObject(%client, %camera);
                              Client::setOwnedObject(%client, %player);
							  $EngineerTurretOwnedBy[%camera] = %client;
							  $EngineerTurretConfig[%camera] = 1; // Set To Snare Trap.
							  Client::sendMessage(%client,3,"Engineer Turret: Set to 'Snare Trap'");
							  Client::sendMessage(%client,3,"Engineer Turret: Touch to change modes.");
					return true;
				}
				else 
					Client::sendMessage(%client,0,"Deploy position out of range");
			}
			else																						  
			 	Client::sendMessage(%client,0,"Deployable Item limit reached for " @ %item.description @ "s");

		return false;
	}


$InvList[EngineerTurretPack] = 1;
$RemoteInvList[EngineerTurretPack] = 1;

TurretData DeployableEngineerTurret
{
	className = "Turret";
	shapeFile = "camera";
        projectileType = EngineerTurretCharge;
	maxDamage = 0.85;
        maxEnergy = 300;
        minGunEnergy = 5;
        maxGunEnergy = 1;
	sequenceSound[0] = { "deploy", SoundActivateMotionSensor };
        reloadDelay = 0.1;
	speed = 14.0;
	speedModifier = 1.5;
        range = 50;
	visibleToSensor = true;
	shadowDetailMask = 4;
	dopplerVelocity = 0;
	castLOS = true;
	supression = false;
	mapFilter = 2;
	mapIcon = "M_camera";
	debrisId = flashDebrisLarge;
	shieldShapeName = "shield";
        fireSound = SoundELFFire; //SoundPickupAmmo;
	activationSound = SoundRemoteTurretOn;
	deactivateSound = SoundRemoteTurretOff;
	explosionId = mortarExp;
        description = "Engineer Turret";
	damageSkinData = "objectDamageSkins";

   isSustained     = true;
   firingTimeMS    = 5000;
   energyRate      = 1.0;
};

function DeployableEngineerTurret::onAdd(%this)
{
        schedule("DeployableEngineerTurret::deploy(" @ %this @ ");",1,%this);
        GameBase::setRechargeRate(%this,15);
        %this.shieldStrength = 0.005;
	if (GameBase::getMapName(%this) == "") {
                GameBase::setMapName (%this, "Engineer Turret");
	}
}

function DeployableEngineerTurret::deploy(%this)
{
	GameBase::playSequence(%this,1,"deploy");
}

function DeployableEngineerTurret::onEndSequence(%this,%thread)
{
	GameBase::setActive(%this,true);
}

function DeployableEngineerTurret::onDestroyed(%this)
{
	Turret::onDestroyed(%this);
        $TeamItemCount[GameBase::getTeam(%this) @ "EngineerTurretPack"]--;
		$EngineerTurretMine = "";
}

// Override base class just in case.
function DeployableEngineerTurret::onPower(%this,%power,%generator) {}
function DeployableEngineerTurret::onEnabled(%this) 
{
        GameBase::setRechargeRate(%this,10);
	GameBase::setActive(%this,true);
}	

function EngineerTurretClear(%object){$EngineerTurretMine[%object] = "";}

function DeployableEngineerTurret::onCollision(%this, %object)
{
		schedule("playSound(SoundBeaconUse,GameBase::getPosition(" @ %this @ "));",0.1);

	%TargetTeam = GameBase::getTeam(%object);
	%thisTeam = GameBase::getTeam(%this);
	if(%targetTeam != %thisTeam)
	{
		if($EngineerTurretMine[%object] != True)
		{
			%team = GameBase::getTeam(%this);
			%objectPos = Gamebase::getPosition(%object);
			%obj = newObject("","Mine","AntipersonelMine");
			addToSet("MissionCleanup", %obj);
			GameBase::setPosition(%obj, %objectPos);
			GameBase::setTeam(%obj,%team);
			$EngineerTurretMine[%object] = True;
			schedule("EngineerTurretClear("@%object@");",3);
		}
	}
	if(%targetTeam == %thisTeam)
	{
		%stranger = Player::getClient(%object);
		if($EngineerTurretOwnedBy[%this] == %stranger)
		{
			if($EngineerTurretConfig[%this] == 11)
			{
				$EngineerTurretConfig[%this] = 1; 
			}
			else
			{
				$EngineerTurretConfig[%this] = $EngineerTurretConfig[%this]+1;
			}
			if($EngineerTurretConfig[%this] == 1)
			{
				  Client::sendMessage(%stranger,3,"Engineer Turret: Set to 'Snare Trap'");
			}
			if($EngineerTurretConfig[%this] == 2)
			{
				  Client::sendMessage(%stranger,3,"Engineer Turret: Set to 'Repulsion'");
			}
			if($EngineerTurretConfig[%this] == 3)
			{
				  Client::sendMessage(%stranger,3,"Engineer Turret: Set to 'Anti-Gravity'");
			}
			if($EngineerTurretConfig[%this] == 4)
			{
				  Client::sendMessage(%stranger,3,"Engineer Turret: Set to 'Hyper-Gravity'");
			}
			if($EngineerTurretConfig[%this] == 5)
			{
				  Client::sendMessage(%stranger,3,"Engineer Turret: Set to 'Speed Trap");
			}
			if($EngineerTurretConfig[%this] == 6)
			{
				  Client::sendMessage(%stranger,3,"Engineer Turret: Set to 'Speed Trap/Anti-Gravity'");
			}
			if($EngineerTurretConfig[%this] == 7)
			{
				  Client::sendMessage(%stranger,3,"Engineer Turret: Set to 'Speed Trap/Hyper-Gravity'");
			}
			if($EngineerTurretConfig[%this] == 8)
			{
				  Client::sendMessage(%stranger,3,"Engineer Turret: Set to 'Energy Leech'");
			}
			if($EngineerTurretConfig[%this] == 9)
			{
				  Client::sendMessage(%stranger,3,"Engineer Turret: Set to 'Disarming Turret'");
			}
			if($EngineerTurretConfig[%this] == 10)
			{
				  Client::sendMessage(%stranger,3,"Engineer Turret: Set to 'Mortar Targetting'");
			}
			if($EngineerTurretConfig[%this] == 11)
			{
				  Client::sendMessage(%stranger,3,"Engineer Turret: Set to 'Anti-Pilot'");
			}
		}
	}
}

function DeployableEngineerTurret::verifyTarget(%this, %target)
{
 %thisPos = GameBase::getPosition(%this);
 %targetPos = GameBase::getPosition(%target);
 %dist = Vector::getDistance(%thisPos, %targetPos);
 	%client = GameBase::getControlClient(%target);
 if(%dist <= 50)
 {
   if($EngineerTurretCanShoot[%client] == true)
   {
	if($EngineerTurretConfig[%this] == 1) // Snare Trap
	{
		EngineerTurretTrap(%this, %target);
	}
	if($EngineerTurretConfig[%this] == 2) // Repulsion
	{
		EngineerTurretTrap(%this, %target, repel);
	}
	if($EngineerTurretConfig[%this] == 3) // Anti-Gravity
	{
		Player::ApplyImpulse(%target,"0 0 15");
	}
	if($EngineerTurretConfig[%this] == 4) // Hyper-Gravity
	{
		Player::ApplyImpulse(%target,"0 0 -15");
	}
	if($EngineerTurretConfig[%this] == 5) // Speed Trap
	{
		Item::setVelocity(%target,"0 0 0");
	}
	if($EngineerTurretConfig[%this] == 6) // Speed Trap/Anti-Gravity
	{
		Item::setVelocity(%target,"0 0 5");
	}
	if($EngineerTurretConfig[%this] == 7) // Speed Trap/Hyper-Gravity
	{
		Item::setVelocity(%target,"0 0 -5");
	}
	if($EngineerTurretConfig[%this] == 8) // Energy Leech
	{
		%energy = GameBase::getEnergy(%target);
		%leech = %energy*0.9;
		if(%energy >=0.1)
		{
			GameBase::setEnergy(%target,%leech);
		}
	}
	if($EngineerTurretConfig[%this] == 9) // Disarming Turret
	{
		%weapon = Player::getMountedItem(%target,$WeaponSlot);
		if(%weapon != "")
		{
			Player::dropItem(%target,%weapon);
		}
	}
	if($EngineerTurretConfig[%this] == 10) // Mortar Targetting
	{
		GameBase::setIsTarget(%client,true);
	}
	if($EngineerTurretConfig[%this] == 11) // Anti-Pilot
	{
//		if (GameBase::virtual(%target, "getMountObject") >= 1)
		%Owner = GameBase::getOwnerClient(%target);
		if (Player::getMountObject(%target) >= 1)
		{
			%pilot = Player::getMountObject(%Owner);
			remoteEval(%client, Vehicle::jump, %pilot);
//			Vehicle::jump(%target,"0 0 200");
			schedule("Vehicle::dismount("@%pilot@");",1);
echo(%target);
		}
	}
	$EngineerTurretCanShoot[%client] = False;
   }
  return True;
 }
 else
 {
  return False;
 }
 echo("Turret Range = "@%this.range);
 echo("Current Dist = "@%dist);
}

MiniMod::MonitorFile(stop, "Engineer Turret.CodeFusion.cs", "A Multi-purpose, user configurable turret.");
